<?php

namespace App\Modules\AdminRole\Domain;

class AdminRole {

    private AdminRoleName $name;
    private AdminRoleAbrv $abrv;
    private AdminRoleLock $lock;
    private AdminRoleStatus $status;
    private ?IdAdminRole $id;

    /** constructor */
    public function __construct (
        AdminRoleName $name,
        AdminRoleAbrv $abrv,
        AdminRoleLock $lock,
        AdminRoleStatus $status,
        ?IdAdminRole $id = NULL
    ) {
        $this->name = $name;
        $this->abrv = $abrv;
        $this->lock = $lock;
        $this->status = $status;
        $this->id = $id;
    }


    public function getName():AdminRoleName { return $this->name; }
    public function getAbrv():AdminRoleAbrv { return $this->abrv; }
    public function getLock():AdminRoleLock { return $this->lock; }
    public function getStatus():AdminRoleStatus { return $this->status; }
    public function getId():IdAdminRole { return $this->id; }
}