<?php

namespace App\Modules\Admin\Infrastructure;

class AdminValidators
{
    public static function insert()
    {
        return [
            'Admin_Name'            => 'required|string|max:100',
            'Admin_LastName'        => 'required|string|max:100',
            'Admin_Abrv'            => 'required|string|max:4',
            'Admin_NoDocument'      => 'required|string|max:20',
            'Admin_Email'           => 'required|string|email|max:250',
            'Admin_EmailAddress'    => 'string|email|max:255',
            'Admin_Address'         => 'required|string|max:250',
            'Admin_Phone'           => 'required|string|max:50',
            'Admin_Color'           => 'required|string|max:250',
            'Admin_IsAssignable'    => 'required|int',
            'Admin_ImgProfile'      => 'image|mimes:' . config("var.MIME_IMG"),
            'Admin_Status'          => 'required|int',
            'Id_TypeDocument'       => 'required|int',
            'Id_AdminRole'          => 'required|int',
            'Id_Country'            => 'required|int',
            'Id_State'              => 'required|int',
            'Id_City'               => 'required|int'
        ];
    }

    public static function update()
    {
        return [
            'Id_Admin'              => 'required|int',
            'Admin_Name'            => 'required|string|max:100',
            'Admin_LastName'        => 'required|string|max:100',
            'Admin_Abrv'            => 'required|string|max:4',
            'Admin_NoDocument'      => 'required|string|max:20',
            'Admin_Email'           => 'required|string|email|max:250',
            'Admin_EmailAddress'    => 'string|email|max:255',
            'Admin_Address'         => 'required|string|max:250',
            'Admin_Phone'           => 'required|string|max:50',
            'Admin_Color'           => 'required|string|max:250',
            'Admin_IsAssignable'    => 'required|int',
            'Admin_ImgProfile'      => 'image|mimes:' . config("var.MIME_IMG"),
            'Admin_Status'          => 'required|int',
            'Id_TypeDocument'       => 'required|int',
            'Id_AdminRole'          => 'required|int',
            'Id_Country'            => 'required|int',
            'Id_State'              => 'required|int',
            'Id_City'               => 'required|int'
        ];
    }

    public const UPDATE_CURRENT_PASSWORD = [
        'Admin_Password'        => 'required|string|max:250',
        'Admin_Password_New'    => 'required|string|max:250'
    ];

    public const CHANGE_PASSWORD = [
        'Id_Admin'              => 'required|int',
        'Admin_Password'        => 'required|string|max:250',
        'Admin_Password_New'    => 'required|string|max:250'
    ];
}
