<?php

namespace App\Modules\Admin\Application\Update;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Admin\Domain\AdminAbrv;
use App\Modules\Admin\Domain\AdminAddress;
use App\Modules\Admin\Domain\AdminColor;
use App\Modules\Admin\Domain\AdminEmail;
use App\Modules\Admin\Domain\AdminEmailAddress;
use App\Modules\Admin\Domain\AdminImgProfile;
use App\Modules\Admin\Domain\AdminImgProfileThumb;
use App\Modules\Admin\Domain\AdminIsAssignable;
use App\Modules\Admin\Domain\AdminLastName;
use App\Modules\Admin\Domain\AdminName;
use App\Modules\Admin\Domain\AdminNoDocument;
use App\Modules\Admin\Domain\AdminPhone;
use App\Modules\Admin\Domain\AdminStatus;
use App\Modules\Admin\Domain\UpdateAdmin;
use App\Modules\AdminRole\Domain\IdAdminRole;
use App\Modules\City\Domain\IdCity;
use App\Modules\Country\Domain\IdCountry;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\State\Domain\IdState;
use App\Modules\TypeDocument\Domain\IdTypeDocument;

final class AdminUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private AdminUpdater $updater)
    {
    }

    public function __invoke(AdminUpdaterQuery $query): AdminUpdaterResponse
    {
        $model = new UpdateAdmin(
            new AdminName($query->name()),
            new AdminLastName($query->lastName()),
            new AdminAbrv($query->abrv()),
            new AdminNoDocument($query->noDocument()),
            new AdminEmail($query->email()),
            new AdminEmailAddress($query->emailAddress()),
            new AdminAddress($query->address()),
            new AdminPhone($query->phone()),
            new AdminColor($query->color()),
            new AdminIsAssignable($query->isAssignable()),
            new AdminImgProfile($query->imgProfile()),
            new AdminImgProfileThumb($query->imgProfileThumb()),
            new AdminStatus($query->status()),
            new IdTypeDocument($query->idTypeDocument()),
            new IdAdminRole($query->idAdminRole()),
            new IdCountry($query->idCountry()),
            new IdState($query->idState()),
            new IdCity($query->idCity()),
            new IdAdmin($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
