<?php

namespace App\Modules\Admin\Application\List;

use App\Modules\Admin\Application\List\AdminListerResponse;
use App\Modules\Admin\Domain\AdminRepository;

final class AdminLister
{
    public function __construct(private AdminRepository $repository)
    {
    }

    public function __invoke(string $action): AdminListerResponse
    {
        return new AdminListerResponse($this->repository->find($action));
    }
}
