<?php

namespace App\Http\Helpers;

class ResponseBuilder
{

    public static function build($response, $data, $domain = null)
    {
        return [
            "Response_Status"           => $response[0]->Response_Status,
            "Response_Code"             => $response[0]->Response_Code,
            "Response_Domain"           => $domain ?? 'global',
            "Response_Message"          => $response[0]->Response_Message,
            "Response_Data"             => $data,
            "Response_Error_Message"    => $response[0]->Response_Message,
            "Response_Error_Reason"     => $response[0]->Response_Reason,
        ];
    }

    public static function buildSelectResponse($data, $message = '', $domain = null)
    {
        return [
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Domain"           => $domain ?? 'global',
            "Response_Message"          => $message,
            "Response_Data"             => $data,
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ];
    }

    public static function Response($oParams)
    {
        $response = self::buildResponse($oParams);
        //
        // RETORNA LA RESPUESTA
        //
        // $oResponse = self::convert_to_utf8_recursively($oResponse);
        $response = response()->json($response, $oParams["Response_Status"])
            ->header("X-Salkantay-API-Version", "1.0.0")
            ->header("X-Salkantay-API-Enviroment", "development");
        return $response;
    }

    private static function buildResponse($oParams)
    {
        $oResponse = array();

        if ($oParams["Response_Code"] == 200) {
            $Success = true;
        } else {
            $Success = false;
        }

        if ($oParams["Response_Data"] != null) {
            $Data_Count = count($oParams["Response_Data"]);
        } else {
            $Data_Count = null;
        }

        //
        // GENERA LA RESPUESTA
        //
        $oResponse["date"]          = date("d-m-Y H:i:s");
        $oResponse["code"]          = $oParams["Response_Code"];
        $oResponse["success"]       = $Success;
        $oResponse["domain"]        = $oParams["Response_Domain"];
        $oResponse["message"]       = $oParams["Response_Message"];
        $oResponse["data-count"]    = $oParams["Response_Count"] ?? $Data_Count;
        $oResponse["data"]          = $oParams["Response_Data"];
        $oResponse["error"]         = self::Response_Error($oParams);
        return $oResponse;
    }

    private static function Response_Error($oParams)
    {
        $oResponse = array();

        if ($oParams["Response_Error_Reason"] != "" and $oParams["Response_Error_Message"] != "") {
            $oResponse["message"]       = $oParams["Response_Error_Message"];
            $oResponse["reason"]        = $oParams["Response_Error_Reason"];
        } else {
            $oResponse = null;
        }

        return $oResponse;
    }
}
