<?php

namespace App\Http\Controllers\Passenger\GroupPassenger;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\GroupPassenger\Application\UpdateStatus\UpdateStatusGroupPassengerQuery;
use App\Modules\GroupPassenger\Infraestructure\GroupPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

final class GroupPassengerUploadMediaController extends Controller
{
    private string $domain = 'GroupPassenger';
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->history = new HistoryData(HistoryTables::GROUP_PASSENGER);
    }

    public function __invoke(Request $request, $Id_GroupPassenger)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, GroupPassengerValidators::UPLOAD_STATUS);

        $this->history->obtainOld($Id_GroupPassenger);
        $this->transaction->begin();
        $this->queryBus->ask(new UpdateStatusGroupPassengerQuery(
            $Id_GroupPassenger,
            $request->input('GroupPassenger_MediaStatus'),
        ));
        $this->transaction->commit();
        $this->history->updateBasic($Id_GroupPassenger, $request);
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Pasajero de grupo modificado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
