<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;

class c_UpgradeExtraEquipment extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Upgrade - Extra - Equipment";
    }
    
	public function List (Request $Request, $Id) {
		$oResponse  = array();
		$oValParams = [
            'Id_TypeUpgrade'	=> 'required|int',
            'Id_TypeExtra'      => 'required|int',
            'Id_TypeEquipment'  => 'required|int'
        ];


		$oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {		
            
            $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);

            if ($oResponse["Response_Code"] == 200) {

                $oData  = array_merge (
                    DB::select ('call sp_upgrade_list(?, ?)', [ $Id, $Request->input("Id_TypeUpgrade") ]),
                    DB::select ('CALL sp_extra_list(?, ?)', [ $Id, $Request->input("Id_TypeExtra") ]),
                    DB::select ('CALL sp_equipment_list(?, ?)', [ $Id, $Request->input("Id_TypeEquipment") ])
                );

                $oResponse["Response_Status"]			= 200;
                $oResponse["Response_Code"]				= 200;
                $oResponse["Response_Domain"]			= $this->oDomain;
                $oResponse["Response_Message"]			= $this->oDomain." list ".$Id;
                $oResponse["Response_Data"]				= $oData;
                $oResponse["Response_Error_Message"]	= "";
                $oResponse["Response_Error_Reason"]		= "";
            }
			
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	
}