<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Intervention\Image\ImageManagerStatic as Image;

class c_Invoice_Fee extends Controller
{
	private $oDomain;
	static $staticDomain = "Invoice Fee";

	public function __construct()
	{
		$this->oDomain = "Invoice Fee";
	} 

	public function Index(Request $Request, $Id){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id );
			$oData  = DB::select('call sp_invoice_fee_index(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);	
	}
	public function List(Request $Request, $Id_Invoice){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id_Invoice,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id_Invoice );
			$oData  = DB::select('call sp_invoice_fee_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);	
	}
	public static function ListAll(Request $Request){
		$oSucces	= true;
		$oResponse  = array();
		$oValParams = array( 'Invoices'	=> 'required|string');
		
		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,self::$staticDomain);
				
		//  INGRESANDO DATOS

		if ($oResponse["Response_Code"] == 200) {
			
			$oData = self::GetAll($Request->input('Invoices'));
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= self::$staticDomain;
			$oResponse["Response_Message"]			= self::$staticDomain." list All ";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public static function GetAll(string $invoiceListJSON){
		$oInvoices = json_decode($invoiceListJSON);
		$oData=[];

		for($k = 0; $k < count($oInvoices); $k++){				
			$oParam = array($oInvoices[$k]->Id);

			$oData=array_merge($oData, DB::select('call sp_invoice_fee_list(?)',$oParam));	
		}
		return $oData;			
	}
	
}