<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Providers\ExcelInvoiceListReport\ExcelInvoiceListReport;
use App\Http\Controllers\Owner\c_Invoice_Detail;
use App\Http\Controllers\Owner\CashMovementDetail;
use App\Http\Controllers\Owner\c_Invoice_Fee;
use Illuminate\Support\Facades\DB;

class c_Invoice extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Invoice";
    }

    public static function findBooking($Id_Invoice)
    {
        $found = DB::select('CALL `sp_invoice_get`(?)', [$Id_Invoice]);
        return count($found) ? $found[0]->Id_Booking : null;
    }

    public function List(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam         = array($Id, config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB'));
            $oData          = DB::select('call sp_invoice_list(?,?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list " . $Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function reportExcel(Request $Request)
    {

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, [
            'Id_Booking'    =>  'required|int',
            'Invoices'      =>  'required|string',
        ], $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $invoiceIds = json_decode($Request->input('Invoices'));

            $invoices = [(object)[]];

            $oParam         = array($Request->input('Id_Booking'));
            $oDataBooking   = DB::select('call sp_booking_index(?)', $oParam);


            $invoices[0]->Booking = $oDataBooking;
            $invoices[0]->Invoice_Detail = c_Invoice_Detail::GetAll($Request->input('Invoices'))["Invoices"];
            $invoices[0]->Invoice_Fee = c_Invoice_Fee::GetAll($Request->input('Invoices'));
            $invoices[0]->Pays = CashMovementDetail::getAll($Request->input('Invoices'));
            $invoices[0]->InvoiceRes = self::GetAll($Request->input('Invoices'));
            (new ExcelInvoiceListReport())->exportToExcel([$invoices]);
        } else {
            return ResponseBuilder::Response($oResponse);
        }
    }
    public function GetReportAll(Request $Request)
    {

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, [
            'Id_Booking'    =>  'required|int',
            'Invoices'      =>  'required|string',
        ], $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $invoiceIds = json_decode($Request->input('Invoices'));

            $invoices = [(object)[]];

            $oParam         = array($Request->input('Id_Booking'));
            $oDataBooking   = DB::select('call sp_booking_index(?)', $oParam);


            $invoices[0]->Booking = $oDataBooking;
            $invoices[0]->Invoice_Detail = c_Invoice_Detail::GetAll($Request->input('Invoices'))["Invoices"];
            $invoices[0]->Invoice_Fee = c_Invoice_Fee::GetAll($Request->input('Invoices'));
            $invoices[0]->Pays = CashMovementDetail::getAll($Request->input('Invoices'));
            $invoices[0]->InvoiceRes = SELF::GetAll($Request->input('Invoices'));

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list ";
            $oResponse["Response_Data"]             = $invoices;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }
        return ResponseBuilder::Response($oResponse);
    }
    public static function GetAll(string $invoiceListJSON)
    {
        $oInvoices = json_decode($invoiceListJSON);
        $oData = [];
        $total = 0;
        $pending = 0;
        $pay = 0;
        for ($k = 0; $k < count($oInvoices); $k++) {
            $oParam = array($oInvoices[$k]->Id);

            $oData = DB::select('call sp_invoice_get(?)', $oParam);

            $total += $oData[0]->Invoice_Total;
            $pending += $oData[0]->Invoice_TotalPending;
            $pay += $oData[0]->Invoice_TotalPay;
        }
        $oData[0] = [
            "Total"      => $total,
            "TotalPay"   => $pay,
            'TotalPending' => $pending
        ];

        return $oData[0];
    }
    public function GetReport(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam     = array($Id);
            $oData      = DB::select('call sp_invoice_get(?)', $oParam);

            if (count($oData)) {
                $oData[0]->Invoice_Detail   = DB::select('call sp_invoice_detail_list(?)', $oParam);
                $oData[0]->Invoice_Fee      = DB::select('call sp_invoice_fee_list(?)', $oParam);
                $oParam                     = array($oData[0]->Id_Booking);
                $oData[0]->User             = DB::select('call sp_booking_index(?)', $oParam);
            }

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
