<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlCamp\Application\HtlCampDeleter;
use App\Modules\HtlCamp\Application\HtlCampFinder;
use App\Modules\HtlCamp\Application\HtlCampIndexer;
use App\Modules\HtlCamp\Application\HtlCampInserter;
use App\Modules\HtlCamp\Application\HtlCampUpdater;
use App\Modules\HtlCamp\Domain\HtlCampAbrv;
use App\Modules\HtlCamp\Domain\HtlCampAvailability;
use App\Modules\HtlCamp\Domain\HtlCampIcon;
use App\Modules\HtlCamp\Domain\HtlCampIconThumb;
use App\Modules\HtlCamp\Domain\HtlCampName;
use App\Modules\HtlCamp\Domain\HtlCampOrder;
use App\Modules\HtlCamp\Domain\HtlCampStatus;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlCamp\Domain\InsertHtlCamp;
use App\Modules\HtlCamp\Domain\UpdateHtlCamp;
use App\Modules\HtlCamp\Infraestructure\HtlCampValidators;
use App\Modules\HtlCamp\Infraestructure\MysqlHtlCampRepository;
use App\Modules\HtlTypeCamp\Domain\IdHtlTypeCamp;
use App\Modules\Image\Domain\ImageThumbnailData;
use App\Modules\Image\Infraestructure\BasicConfigImageStorage;
use App\Modules\Shared\Domain\ImageUtils;
use App\Modules\Shared\Infraestructure\LaravelExceptionHandler;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Throwable;

class c_HtlCamp extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "HtlCamp";
        $this->history = new HistoryData(HistoryTables::HTL_CAMP);
    }

    public function Insert(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, HtlCampValidators::insert());

        $thumbnail = new ImageThumbnailData(
            config("var.THUMB_W"),
            config("var.THUMB_H")
        );

        $image = (new BasicConfigImageStorage($Request))->storeImage(
            'htl_camp' . DIRECTORY_SEPARATOR . 'icon',
            'HtlCamp_Icon',
            $thumbnail
        );

        $oResponse = (new HtlCampInserter(new MysqlHtlCampRepository))->__invoke(
            new InsertHtlCamp(
                new HtlCampName(Str::title($Request->input('HtlCamp_Name'))),
                new HtlCampAbrv(Str::upper($Request->input('HtlCamp_Abrv'))),
                new HtlCampIcon(isset($image) ? $image->getUrl() : ''),
                new HtlCampIconThumb(isset($image) ? $image->getThumbnail() : ''),
                new HtlCampAvailability($Request->input('HtlCamp_Availability')),
                new HtlCampStatus($Request->input('HtlCamp_Status')),
                new IdHtlTypeCamp($Request->input('Id_HtlTypeCamp')),
            )
        );

        $this->history->insert(
            (new HtlCampIndexer(new MysqlHtlCampRepository))->__invoke(new IdHtlCamp($oResponse['Response_Data']['Id'])),
            $Request,
            $oResponse['Response_Data']['Id']
        );

        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, HtlCampValidators::update());

        $this->history->obtainOld($Request->input('Id_HtlCamp'));

        $thumbnail = new ImageThumbnailData(
            config("var.THUMB_W"),
            config("var.THUMB_H")
        );

        $image = (new BasicConfigImageStorage($Request))->storeImage('htl_camp' . DIRECTORY_SEPARATOR . 'icon', 'HtlCamp_Icon', $thumbnail);

        /** @var HtlCampIndexerResponse $indexResponse */
        $indexResponse = (new HtlCampIndexer(new MysqlHtlCampRepository))->__invoke(new IdHtlCamp($Request->input("Id_HtlCamp")));
        $icon = $this->indexOrEmpty($indexResponse, 'HtlCamp_Icon');
        $iconThumb = $this->indexOrEmpty($indexResponse, 'HtlCamp_Icon_Thumb');

        $oResponse = (new HtlCampUpdater(new MysqlHtlCampRepository))->__invoke(
            new UpdateHtlCamp(
                new HtlCampName(Str::title($Request->input('HtlCamp_Name'))),
                new HtlCampAbrv(Str::upper($Request->input('HtlCamp_Abrv'))),
                new HtlCampIcon(isset($image) ? $image->getUrl() : $icon),
                new HtlCampIconThumb(isset($image) ? $image->getThumbnail() : $iconThumb),
                new HtlCampAvailability($Request->input('HtlCamp_Availability')),
                new HtlCampOrder($Request->input('HtlCamp_Order')),
                new HtlCampStatus($Request->input('HtlCamp_Status')),
                new IdHtlTypeCamp($Request->input('Id_HtlTypeCamp')),
                new IdHtlCamp($Request->input('Id_HtlCamp'))
            )
        );

        $this->history->update(
            $Request->input('Id_HtlCamp'),
            $this->history->oldValue,
            [],
            $Request
        );
        return ResponseBuilder::Response($oResponse);
    }

    public function Delete(Request $request, $Id)
    {
        try {
            return $this->DeleteFunction($request, $Id);
        } catch (Throwable $ex) {
            return (new LaravelExceptionHandler())->handle($ex);
        }
    }

    public function DeleteFunction(Request $request, $Id)
    {
        $this->history->obtainOld($Id);

        $oResponse = (new HtlCampDeleter(new MysqlHtlCampRepository))->__invoke(new IdHtlCamp($Id));

        $this->history->delete(
            $Id,
            $this->history->oldValue,
            $request
        );

        return ResponseBuilder::Response($oResponse);
    }

    public function Index($Id)
    {
        $oResponse = (new HtlCampIndexer(new MysqlHtlCampRepository))->__invoke(new IdHtlCamp($Id));
        $oResponse['Response_Data'] = array_map(
            fn ($htlCamp) => self::appendPath($htlCamp),
            $oResponse['Response_Data']
        );
        return ResponseBuilder::Response($oResponse);
    }

    public function List($Action, Request $Request)
    {
        $query = $Request->input("query") ? $Request->input("query") : '';
        $oResponse = (new HtlCampFinder(new MysqlHtlCampRepository))->__invoke($Action, $query);
        $oResponse['Response_Data'] = array_map(
            fn ($htlCamp) => self::appendPath($htlCamp),
            $oResponse['Response_Data']
        );
        return ResponseBuilder::Response($oResponse);
    }

    public static function appendPath($htlCamp)
    {
        ImageUtils::appendPath($htlCamp, 'HtlCamp_Icon');
        return ImageUtils::appendPath($htlCamp, 'HtlCamp_Icon_Thumb');
    }

    private function indexOrEmpty($response, $key)
    {
        if (count($response['Response_Data'])) {
            return $response['Response_Data'][0]->{$key};
        } else {
            return '';
        }
    }
}
