<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Intervention\Image\ImageManagerStatic as Image;

class c_Credential extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Credential";
		$this->history = new HistoryData (HistoryTables::credential);
	}


	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'pId_Credential'		=> 'required|int',
								'pCredential_Value'		=> 'required|string'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			//region HISTORY VARIABLES
			$this->history->obtainOld($Request->input('pId_Credential'));
			//endregion

			$oParam = array(	$Request->input("pId_Credential"),
								$Request->input("pCredential_Value")
							);
			$oData = DB::select('call sp_credential_update(?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("pId_Credential"), $Request );
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_credential_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request){
		$oResponse  = array();

		$oData  = DB::select('call sp_credential_list()');

		$oResponse["Response_Status"]			= 200;
		$oResponse["Response_Code"]				= 200;
		$oResponse["Response_Domain"]			= $this->oDomain;
		$oResponse["Response_Message"]			= $this->oDomain." list ";
		$oResponse["Response_Data"]				= $oData;
		$oResponse["Response_Error_Message"]	= "";
		$oResponse["Response_Error_Reason"]		= "";

		return ResponseBuilder::Response($oResponse);
	}
	
}