<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;

class c_Category_Tour extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Category Tour";
		$this->history = new HistoryData (HistoryTables::category_tour);
	}

	public function Insert(Request $Request){
		$oResponse  = array();
        $oValParams = array(    'CategoryTour_Name'     => 'required|string|max:250',
								'CategoryTour_Status'   => 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			

			//region INSERTA DATOS

            $oParam = array(    Str::title( $Request->input("CategoryTour_Name")),
											$Request->input("CategoryTour_Status")
							);
			$oData = DB::select('call sp_category_tour_insert(?,?)',$oParam);

			//endregion

			$data = null;
			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				$this->history->insertBasic ($Request);
				$data = ['Id' => $oData[0]->Response_Id];
			} else {
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= $data;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_CategoryTour'       => 'required|int',
                                'CategoryTour_Name'     => 'required|string|max:250',
                                'CategoryTour_Status'   => 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$this->history->obtainOld($Request->input('Id_CategoryTour'));
			
			//region ACTUALIZA DATOS

			$oParam = array(    			$Request->input("Id_CategoryTour"),
                                Str::title( $Request->input("CategoryTour_Name")),
                                            $Request->input("CategoryTour_Status")
							);
			$oData = DB::select('call sp_category_tour_update(?,?,?)',$oParam);

			//endregion

			//  RESPONSE
			if($oData[0]->Response_Success == 1) {
				//region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("Id_CategoryTour"), $Request );
				//endregion
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {

			//region HISTORY
			$this->history->obtainOld($Id);
			//endregion

			//region ELIMINA DATOS

			$oParam = array( $Id );
			$oData 	= DB::select('call sp_category_tour_delete(?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				//region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				//endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_category_tour_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id );
			$oData  = DB::select('call sp_category_tour_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list ".$Id;
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	public function Selector(Request $Request,$Id){
		if( is_numeric($Id) ){
			return SELF::Index( $Request,$Id );
		}else{
			return SELF::List( $Request,$Id );
		}
	}
	
}