<?php

namespace App\Http\Controllers\Owner\WebContactMessage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\WebContactMessage\Application\List\ListWebContactMessageQuery;
use App\Modules\WebContactMessage\Application\List\ListWebContactMessageQueryResponse;

class WebContactMessageListController extends Controller
{
    private $domain = 'WebContactMessage';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id_WebContact, $Action, Request $Request)
    {
        /** @var ListWebContactMessageQueryResponse $response */
        $response = $this->queryBus->ask(new ListWebContactMessageQuery($Id_WebContact, $Action));
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
