<?php

namespace App\Http\Controllers\Owner\WebContactMessage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\WebContactMessage\Application\Create\CreateWebContactMessageQuery;
use App\Modules\WebContactMessage\Application\Create\CreateWebContactMessageResponse;
use App\Modules\WebContactMessage\Infraestructure\WebContactMessageValidators;

class WebContactMessageInsertController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "WebContactMessage";
        $this->history = new HistoryData(HistoryTables::WEB_CONTACT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, WebContactMessageValidators::INSERT);

        /** @var CreateWebContactMessageResponse $response */
        $response = $this->queryBus->ask(new CreateWebContactMessageQuery(
            $request->input('WebContactMessage_DateDeparture'),
            $request->input('WebContactMessage_DateSend'),
            $request->input('WebContactMessage_DateReception'),
            $request->input('WebContactMessage_Name'),
            $request->input('WebContactMessage_LastName'),
            $request->input('WebContactMessage_Email'),
            $request->input('WebContactMessage_Country'),
            $request->input('WebContactMessage_CountryCurrent'),
            $request->input('WebContactMessage_PhoneCode'),
            $request->input('WebContactMessage_Phone'),
            $request->input('Id_Country'),
            $request->input('Id_Country_Current'),
            $request->input('WebContactMessage_Message'),
            $request->input('WebContactMessage_Adults'),
            $request->input('WebContactMessage_Children'),
            $request->input('WebContactMessage_Subscription'),
            $request->input('WebContactMessage_Origin'),
            $request->input('WebContactMessage_Type'),
            $request->input('WebContactMessage_Status'),
            $request->input('Id_WebContact'),
            $request->input('Id_Language'),
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
