<?php

namespace App\Http\Controllers\Owner\TypeBookingAssign;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\TypeBookingAssign\Application\Delete\DeleteTypeBookingAssignQuery;
use App\Modules\TypeBookingAssign\Application\Delete\DeleteTypeBookingAssignQueryResponse;

class TypeBookingAssignDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::TYPE_BOOKING_ASSIGN);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        /** @var DeleteTypeBookingAssignQueryResponse $response */
        $response = $this->queryBus->ask(new DeleteTypeBookingAssignQuery($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response->response());
    }
}
