<?php

namespace App\Http\Controllers\Owner\StatusGroup;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\StatusGroup\Application\Create\CreateStatusGroupQuery;
use App\Modules\StatusGroup\Application\Create\CreateStatusGroupResponse;
use App\Modules\StatusGroup\Infraestructure\StatusGroupValidators;

class StatusGroupInsertController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "StatusGroup";
        $this->history = new HistoryData(HistoryTables::STATUS_GROUP);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, StatusGroupValidators::INSERT);

        /** @var CreateStatusGroupResponse $response */
        $response = $this->queryBus->ask(new CreateStatusGroupQuery(
            $request->input('StatusGroup_Name'),
            $request->input('StatusGroup_Abrv'),
            $request->input('StatusGroup_Color'),
            $request->input('StatusGroup_Status')
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
