<?php
namespace App\Http\Controllers\Owner\QuestionTypeProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\QuestionTypeProvider\Application\List\QuestionTypeProviderListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class QuestionTypeProviderListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($IdQuestion, $Action)
    {
        /** @var QuestionTypeProviderListerResponse $response */
        $response = $this->queryBus->ask(new QuestionTypeProviderListerQuery($IdQuestion, $Action));

        return ResponseBuilder::Response($response->response());
    }
}
