<?php

namespace App\Http\Controllers\Owner\ProviderSanction;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ProviderSanction\Application\List\ProviderSanctionListerQuery;
use App\Modules\ProviderSanction\Application\List\ProviderSanctionListerResponse;
use App\Modules\ProviderSanction\Infraestructure\ProviderSanctionValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class ProviderSanctionListController extends Controller
{
    private $domain;
    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "ProviderSanction";
    }

    public function __invoke(Request $request, $IdProvider, $Action)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ProviderSanctionValidators::LIST);
        /** @var ProviderSanctionListerResponse $response */
        $response = $this->queryBus->ask(new ProviderSanctionListerQuery(
            $IdProvider,
            $Action,
            $request->input('DateStart'),
            $request->input('DateEnd')
        ));

        return ResponseBuilder::Response($response->response());
    }
}
