<?php
namespace App\Http\Controllers\Owner\ProviderSanction;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ProviderSanction\Application\Index\ProviderSanctionIndexerQuery;
use App\Modules\ProviderSanction\Application\Index\ProviderSanctionIndexerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ProviderSanctionIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var ProviderSanctionIndexerResponse $response */
        $response = $this->queryBus->ask(new ProviderSanctionIndexerQuery($Id));

        return ResponseBuilder::Response($response->response());
    }
}
