<?php

namespace App\Http\Controllers\Owner\Passenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Passenger\Application\ReviewReport\PassengerReviewReportQuery;
use App\Modules\Passenger\Application\ReviewReport\PassengerReviewReportResponse;
use App\Modules\Passenger\Infraestructure\PassengerSearchWithReviewValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Infraestructure\QueryList\LaravelListValidator;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

final class SearchWithReview extends Controller
{
    private $oDomain;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->oDomain = 'Passenger';
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), $this->oDomain, PassengerSearchWithReviewValidators::BASIC);
        /**
         * @var PassengerReviewReportResponse $response
         */
        $response = $this->queryBus->ask(
            new PassengerReviewReportQuery(
                $request->input('DateStart'),
                $request->input('DateEnd'),
                $request->input('Range'),
                $request->input('UploadedMediaStatus', 0),
                $request->input('Action'),
            )
        );
        return ResponseBuilder::Response($response->response());
    }
}
