<?php
namespace App\Http\Controllers\Owner\LeadPassenger;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadPassenger\Application\Index\LeadPassengerIndexerQuery;
use App\Modules\LeadPassenger\Application\Index\LeadPassengerIndexerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadPassengerIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var LeadPassengerIndexerResponse $response */
        $response = $this->queryBus->ask(new LeadPassengerIndexerQuery($Id));

        return ResponseBuilder::Response($response->response());
    }
}
