<?php
namespace App\Http\Controllers\Owner\LeadBookingTourPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadBookingTourPassenger\Application\List\LeadBookingTourPassengerListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingTourPassengerListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id_LeadBookingTour, $Action)
    {
        /** @var LeadBookingTourPassengerListerResponse $response */
        $response = $this->queryBus->ask(new LeadBookingTourPassengerListerQuery($Id_LeadBookingTour, $Action));

        return ResponseBuilder::Response($response->response());
    }
}
