<?php

namespace App\Http\Controllers\Owner\LeadBookingServicePassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBookingServicePassenger\Application\Update\LeadBookingServicePassengerUpdaterQuery;
use App\Modules\LeadBookingServicePassenger\Application\Update\LeadBookingServicePassengerUpdaterResponse;
use App\Modules\LeadBookingServicePassenger\Infraestructure\LeadBookingServicePassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingServicePassengerUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingServicePassenger";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_SERVICE_PASSENGER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate(
            $request->all(),
            $this->domain,
            LeadBookingServicePassengerValidators::UPDATE
        );

        $this->history->obtainOld($request->input("Id_LeadBookingServicePassenger"));

        /** @var LeadBookingServicePassengerUpdaterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingServicePassengerUpdaterQuery(
            $request->input('Id_LeadBookingServicePassenger'),
            $request->input('LeadBookingServicePassenger_Status'),
            $request->input('Id_LeadBookingService'),
            $request->input('Id_LeadBookingTourPassenger')
        ));

        $this->history->updateBasic($request->input("Id_LeadBookingServicePassenger"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
