<?php
namespace App\Http\Controllers\Owner\LeadBooking;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadBooking\Application\Delete\LeadBookingDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingDeleteController extends Controller
{
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBooking";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var LeadBookingDeleterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
