<?php

namespace App\Http\Controllers\Owner\Info;

use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CashMovementTempGenerateController
{
    public function __construct(
        private QueryBus $queryBus
    )
    {
        
    }
    public function __invoke(Request $request, $IdCashMovementTemp)
    {
        $niubizPurchase = self::getNiubizPurchase($IdCashMovementTemp);

        $data = self::data($niubizPurchase);
        $request = CashMovementGenerator::from($niubizPurchase, $data);
        $result = CashMovementGenerator::generate($request);
        dd($result);
    }

    private static function idCashMovementTemp($niubizPurchase)
    {
        return $niubizPurchase->Id_CashMovementTemp;
    }

    private static function amount($niubizPurchase)
    {
        return $niubizPurchase->BookingTemp_Amount;
    }

    private static function userEmail($niubizPurchase)
    {
        return $niubizPurchase->BookingTemp_User_Email;
    }

    private static function userId($user)
    {
        return $user->Id_User;
    }

    private static function card($data)
    {
        return $data->dataMap->CARD;
    }

    private static function data($niubizPurchase)
    {
        return json_decode($niubizPurchase->CashMovementTemp_ResponseData);
    }

    private static function searchUser($userEmail)
    {
        return self::index(DB::select('SELECT * FROM t_user WHERE User_Email = ?', [$userEmail]), 'No user found');
    }

    private static function searchBooking($idUser)
    {
        return self::index(DB::select('SELECT * FROM t_booking WHERE Id_User = ?', [$idUser]), 'No booking found');
    }

    private static function indexBooking($idBooking)
    {
        return self::index(DB::select('SELECT * FROM t_booking WHERE Id_Booking = ?', [$idBooking]), 'No booking found');
    }

    private static function getNiubizPurchase($IdCashMovementTemp)
    {
        $np = self::index(DB::select('SELECT * FROM `t_niubiz_purchase` WHERE NiubizPurchase_type = \'CASH_MOVEMENT_TEMP\' AND Id=?;', [$IdCashMovementTemp]), 'No niubiz purchase found');
        return self::index(DB::select('call sp_niubiz_purchase_index(?)', [$np->Id_NiubizPurchase]), 'No niubiz purchase index found');
    }

    private static function index($data, $message)
    {
        if (!count($data)) {
            throw new Exception($message);
        }
        return $data[0];
    }
}
