<?php

namespace App\Http\Controllers\Owner\HtlTypeRoomBed;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlTypeRoomBed\Application\Create\CreateHtlTypeRoomBedQuery;
use App\Modules\HtlTypeRoomBed\Application\Create\CreateHtlTypeRoomBedResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\HtlTypeRoomBed\Infrastructure\HtlTypeRoomBedValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeRoomBedInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlTypeRoomBed";
        $this->history = new HistoryData(HistoryTables::HTL_TYPE_ROOM_BED);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, HtlTypeRoomBedValidators::INSERT);
        $this->transaction->begin();
        /** @var CreateHtlTypeRoomBedResponse $response */
        $response = $this->queryBus->ask(new CreateHtlTypeRoomBedQuery(
            $request->input('HtlTypeRoomBed_Status'),
            $request->input('Id_HtlTypeRoom'),
            $request->input('Id_HtlBed'),
        ));
        $this->history->insertBasic($request, $response->id());
        $this->transaction->commit();
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => ['id' => $response->id()],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Habitación Cama agregado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
