<?php
namespace App\Http\Controllers\Owner\HtlTypeCamp;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlTypeCamp\Application\Delete\DeleteHtlTypeCampQuery;
use App\Modules\HtlTypeCamp\Application\Delete\DeleteHtlTypeCampResponse;
use App\Modules\HtlTypeCamp\Application\Delete\HtlTypeCampDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeCampDeleteController extends Controller
{
    private $domain = "HtlTypeCamp";
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->history = new HistoryData(HistoryTables::HTL_TYPE_CAMP);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->transaction->begin();
        $this->history->obtainOld($Id);
        /** @var DeleteHtlTypeCampResponse $response */
        $response = $this->queryBus->ask(new DeleteHtlTypeCampQuery($Id));

        $this->history->deleteBasic($Id, $request);
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [ ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Campamento eliminado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
