<?php

namespace App\Http\Controllers\Owner\HtlCampBookingPassenger;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\HtlCampBookingPassenger\Application\Update\UpdateHtlCampBookingPassengerQuery;
use App\Modules\HtlCampBookingPassenger\Infrastructure\HtlCampBookingPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlCampBookingPassengerUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlCampBookingPassenger";
        $this->history = new HistoryData(HistoryTables::HTL_CAMP_BOOKING_PASSENGER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, HtlCampBookingPassengerValidators::UPDATE);
        $this->history->obtainOld($request->input('Id_HtlCampBookingPassenger'));
        $this->transaction->begin();
        $this->queryBus->ask(new UpdateHtlCampBookingPassengerQuery(
            $request->input('Id_HtlCampBookingPassenger'),
            $request->input('HtlCampBookingPassenger_Weight'),
            $request->input('HtlCampBookingPassenger_Status'),
        ));
        $this->transaction->commit();
        $this->history->updateBasic($request->input('Id_HtlCampBookingPassenger'), $request);
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Reserva de campamento modificada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
