<?php
namespace App\Http\Controllers\Owner\HtlCampBookingPassenger;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlCampBookingPassenger\Application\Delete\DeleteHtlCampBookingPassengerQuery;
use App\Modules\HtlCampBookingPassenger\Application\Delete\DeleteHtlCampBookingPassengerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlCampBookingPassengerDeleteController extends Controller
{
    private $domain = "HtlCampBookingPassenger";
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->history = new HistoryData(HistoryTables::HTL_CAMP_BOOKING_PASSENGER);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        $this->transaction->begin();
        /** @var DeleteHtlCampBookingPassengerResponse $response */
        $response = $this->queryBus->ask(new DeleteHtlCampBookingPassengerQuery($Id));
        $this->transaction->commit();

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [ ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Reserva de campamento eliminada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
