<?php

namespace App\Http\Controllers\Owner\GroupProviderReview;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupProviderReview\Application\List\GroupProviderReviewListerQuery;
use App\Modules\GroupProviderReview\Application\List\GroupProviderReviewListerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class GroupProviderReviewListFromGroupProviderController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "GroupProviderReview";
    }

    public function __invoke($Id_GroupProvider, $Action)
    {
        /** @var GroupProviderReviewListerResponse $response */
        $response = $this->queryBus->ask(new GroupProviderReviewListerQuery(
            $Id_GroupProvider,
            $Action
        ));
        return ResponseBuilder::Response($response->response());
    }
}
