<?php

namespace App\Http\Controllers\Owner\Group;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Group\Application\CopyProviders\CopyProvidersGroupQuery;
use App\Modules\Group\Application\UpdateStatus\UpdateGroupStatusQueryResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class GroupCopyProvidersController extends Controller
{
    private $domain;

    public function __construct(private QueryBus $queryBus)
    {
        $this->domain = "Group";
    }

    public function __invoke($Id)
    {
        /** @var UpdateGroupStatusQueryResponse $response */
        $response = $this->queryBus->ask(new CopyProvidersGroupQuery($Id));
        return ResponseBuilder::Response($response->response());
    }
}
