<?php

namespace App\Http\Controllers\Owner\FactUnit;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactUnit\Application\FactUnitResponses;
use App\Modules\FactUnit\Application\List\FactUnitListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactUnitListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action)
    {
        /** @var FactUnitResponses $response */
        $response = $this->queryBus->ask(new FactUnitListerQuery($Action));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
