<?php

namespace App\Http\Controllers\Owner\FactReceiptDetail;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactReceiptDetail\Application\Update\FactReceiptDetailUpdaterQuery;
use App\Modules\FactReceiptDetail\Application\Update\FactReceiptDetailUpdaterResponse;
use App\Modules\FactReceiptDetail\Infraestructure\FactReceiptDetailValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactReceiptDetailUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "FactReceiptDetail";
        $this->history = new HistoryData(HistoryTables::FACT_RECEIPT_DETAIL);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactReceiptDetailValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_FactReceiptDetail"));

        /** @var FactReceiptDetailUpdaterResponse $response */
        $response = $this->queryBus->ask(new FactReceiptDetailUpdaterQuery(
            $request->input('Id_FactReceiptDetail'),
            $request->input('FactReceiptDetail_Amount'),
            $request->input('FactReceiptDetail_UnitPrice'),
            $request->input('FactReceiptDetail_Discount'),
            $request->input('FactReceiptDetail_Total'),
            $request->input('Id_FactTypeOperation'),
            $request->input('Id_FactUnit'),
            $request->input('FactProduct_Code'),
            $request->input('FactProduct_Name'),
            $request->input('FactProduct_IdProduct'),
        ));

        $this->history->updateBasic($request->input("Id_FactReceiptDetail"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
