<?php

namespace App\Http\Controllers\Owner\FactReceipt;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactReceipt\Application\FactReceiptResponses;
use App\Modules\FactReceipt\Application\List\FactReceiptListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactReceiptListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action)
    {
        /** @var FactReceiptResponses $response */
        $response = $this->queryBus->ask(new FactReceiptListerQuery($Action));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
