<?php

namespace App\Http\Controllers\Owner\FactReceipt;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\FactReceipt\Application\Create\CreateFactReceiptQuery;
use App\Modules\FactReceipt\Application\Create\CreateFactReceiptResponse;
use App\Modules\FactReceipt\Domain\FactReceiptStatus;
use App\Modules\FactReceipt\Infraestructure\FactReceiptValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

/**
 * This class is a controller for creating fact receipts.
 */
class FactReceiptCreateController
{

    private $domain = 'FactReceipt';
    private HistoryData $history;

    /**
     * Constructs a new instance of the class.
     *
     * @param QueryBus $queryBus The query bus instance.
     */
    public function __construct(
        private QueryBus $queryBus,
    ) {
        $this->history = new HistoryData(HistoryTables::FACT_RECEIPT);
    }

    /**
     * Validates the request, creates a new fact receipt, creates an history entry and returns the created fact receipt.
     */
    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactReceiptValidators::INSERT);

        /**
         * @var CreateFactReceiptResponse $response
         */
        $response = $this->queryBus->ask(new CreateFactReceiptQuery(
            date('Y-m-d H:i:s'),
            date('Y-m-d H:i:s'),
            date('Y-m-d'),
            $request->input('FactReceipt_NoDocument'),
            $request->input('FactReceipt_BusinessName'),
            $request->input('FactReceipt_Email'),
            $request->input('FactReceipt_Address'),
            $request->input('FactReceipt_LicensePlate'),
            $request->input('FactReceipt_Currency'),
            '',
            FactReceiptStatus::PENDING,
            $request->input('Id_FactTypeReceipt'),
            $request->input('Id_FactTypeDocument'),
            $request->input('Id_FactPaymentMethod'),
            $request->input('Id_FactCurrency'),
        ));

        $this->history->insertBasic($request);
        return ResponseBuilder::Response($response->response());
    }
}
