<?php

namespace App\Http\Controllers\Owner\FactPaymentMethod;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactPaymentMethod\Application\Update\UpdateFactPaymentMethodQuery;
use App\Modules\FactPaymentMethod\Infrastructure\FactPaymentMethodValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class FactPaymentMethodUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "FactPaymentMethod";
        $this->history = new HistoryData(HistoryTables::FACT_PAYMENT_METHOD);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactPaymentMethodValidators::UPDATE);
        $this->history->obtainOld($request->input('Id_FactPaymentMethod'));
        $this->transaction->begin();
        $this->queryBus->ask(new UpdateFactPaymentMethodQuery(
            $request->input('Id_FactPaymentMethod'),
            $request->input('FactPaymentMethod_Name'),
            $request->input('FactPaymentMethod_Abrv'),
            $request->input('FactPaymentMethod_Status'),
        ));
        $this->transaction->commit();
        $this->history->updateBasic($request->input('Id_FactPaymentMethod'), $request);
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Metodo de Pago de Facturación modificado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
