<?php

namespace App\Http\Controllers\Owner\CashMovementFactReceipt;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\CashMovement\Application\CreateFactReceipt\CreateFactReceiptCashMovementQuery;
use App\Modules\CashMovement\Application\CreateFactReceipt\CreateFactReceiptCashMovementResponse;
use App\Modules\CashMovementFactReceipt\Application\CashMovementFactReceiptResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\CashMovementFactReceipt\Application\Index\IndexCashMovementFactReceiptQuery;
use App\Modules\CashMovementFactReceipt\Infraestructure\CashMovementFactReceiptValidators;
use App\Modules\FactProduct\Application\Creator\CreateFactProductQuery;
use App\Modules\FactProduct\Application\Creator\CreateFactProductResponse;
use App\Modules\FactProduct\Domain\FactProductStatus;
use App\Modules\FactReceipt\Domain\FactReceiptStatus;
use App\Modules\FactReceiptDetail\Application\Create\CreateFactReceiptDetailQuery;
use App\Modules\FactReceiptDetail\Application\Create\CreateFactReceiptDetailResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\ValueObject\DateTimeValueObject;

class CashMovementFactReceiptCreateController extends Controller
{
    private $domain;
    private HistoryData $history;
    private HistoryData $historyFactReceiptDetail;
    private HistoryData $historyFactProduct;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "CashMovementFactReceipt";
        $this->history = new HistoryData(HistoryTables::FACT_RECEIPT);
        $this->historyFactReceiptDetail = new HistoryData(HistoryTables::FACT_RECEIPT_DETAIL);
        $this->historyFactProduct = new HistoryData(HistoryTables::FACT_PRODUCT);
    }

    public function __invoke(Request $request, $idCashMovement)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, CashMovementFactReceiptValidators::INSERT);

        $now = DateTimeValueObject::reduceDatetimeToPeru(DateTimeValueObject::now())->value();

        /** @var CreateFactReceiptCashMovementResponse $response */
        $response = $this->queryBus->ask(new CreateFactReceiptCashMovementQuery(
            0,
            $now,
            $now,
            $request->input('FactReceipt_DateEmission'),
            $request->input('FactReceipt_NoDocument'),
            $request->input('FactReceipt_BusinessName'),
            $request->input('FactReceipt_Email'),
            $request->input('FactReceipt_Address'),
            $request->input('FactReceipt_LicensePlate'),
            $request->input('FactReceipt_Currency'),
            '',
            FactReceiptStatus::PENDING,
            $request->input('Id_FactTypeReceipt'),
            $request->input('Id_FactTypeDocument'),
            $request->input('Id_FactPaymentMethod'),
            $request->input('Id_FactCurrency'),
            $idCashMovement,
        ));

        $this->history->insert([], $request, $response->response()['Response_Data']['Id']);

        foreach ($request->input('FactReceiptDetail') as $factReceiptDetail) {

            /** @var CreateFactProductResponse $productResponse */
            $productResponse = $this->queryBus->ask(new CreateFactProductQuery(
                0,
                $factReceiptDetail['FactProduct_Code'],
                $factReceiptDetail['FactProduct_Name'],
                '',
                FactProductStatus::ACTIVE
            ));

            $this->historyFactProduct->insert([], $request, $productResponse->response()['Response_Data']['Id']);

            /** @var CreateFactReceiptDetailResponse $responseDetail */
            $responseDetail = $this->queryBus->ask(new CreateFactReceiptDetailQuery(
                $factReceiptDetail['FactReceiptDetail_Amount'],
                $factReceiptDetail['FactReceiptDetail_UnitPrice'],
                $factReceiptDetail['FactReceiptDetail_Discount'],
                $factReceiptDetail['FactReceiptDetail_Total'],
                $factReceiptDetail['FactReceiptDetail_Status'],
                $productResponse->response()['Response_Data']['Id'],
                $factReceiptDetail['Id_FactTypeOperation'],
                $factReceiptDetail['Id_FactUnit'],
                $response->response()['Response_Data']['Id']
            ));

            $this->historyFactReceiptDetail->insert([], $request, $responseDetail->response()['Response_Data']['Id']);
        }

        return ResponseBuilder::Response($response->response());
    }

    public function index($idCashMovementFactReceipt)
    {
        /** @var CashMovementFactReceiptResponse $index */
        $index = $this->queryBus->ask(new IndexCashMovementFactReceiptQuery($idCashMovementFactReceipt));
        return $index;
    }

    public function build($index)
    {
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse([$index]));
    }
}
