<?php

namespace App\Http\Controllers\Owner\CashMovementDetail;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\CashMovementDetail\Application\ListForFacture\ListForFactureCashMovementDetailQuery;
use App\Modules\CashMovementDetail\Application\ListForFacture\ListForFactureCashMovementDetailResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class CashMovementDetailForFactureController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::CASH_MOVEMENT);
    }

    public function __invoke(int $idCashMovement, string $action)
    {
        /** @var ListForFactureCashMovementDetailResponse $response */
        $response = $this->queryBus->ask(new ListForFactureCashMovementDetailQuery($idCashMovement, $action));

        return ResponseBuilder::Response($response->response());
    }
}
