<?php

namespace App\Http\Controllers\Owner\CashMovement;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\CashMovement\Application\UpdateCycleType\UpdateCycleTypeCashMovementQuery;
use App\Modules\CashMovement\Application\UpdateCycleType\UpdateCycleTypeCashMovementResponse;
use App\Modules\CashMovement\Infraestructure\CashMovementValidators;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class CashMovementUpdateCycleTypeController extends Controller
{
  private $domain;
  /** @var HistoryData */
  private $history;

  public function __construct(
    private QueryBus $queryBus
  ) {
    $this->domain = "External";
    $this->history = new HistoryData(HistoryTables::CASH_MOVEMENT);
  }

  public function __invoke(Request $request)
  {
    (new LaravelValidator())->validate($request->all(), $this->domain, CashMovementValidators::UPDATE_CYCLE_TYPE);

    $this->history->obtainOld($request->input("Id_CashMovement"));

    /** @var UpdateCycleTypeCashMovementResponse $response */
    $response = $this->queryBus->ask(new UpdateCycleTypeCashMovementQuery(
      $request->input('Id_CashMovement'),
      $request->input('CashMovement_CycleType')
    ));

    $this->history->updateBasic($request->input("Id_CashMovement"), $request);

    return ResponseBuilder::Response($response->response());
  }
}
