<?php

namespace App\Http\Controllers\Owner\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Admin\Application\Index\AdminIndexerQuery;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\Admin\Application\Update\AdminUpdaterQuery;
use App\Modules\Admin\Application\Update\AdminUpdaterResponse;
use App\Modules\Admin\Infrastructure\AdminValidators;
use App\Modules\Image\Domain\ImageThumbnailData;
use App\Modules\Image\Infraestructure\BasicConfigImageStorage;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Str;

class AdminUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "Admin";
        $this->history = new HistoryData(HistoryTables::ADMIN);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, AdminValidators::update());

        $this->history->obtainOld($request->input('Id_Admin'));

        $thumbnail = new ImageThumbnailData(
            config("var.THUMB_W"),
            config("var.THUMB_H")
        );

        $image = (new BasicConfigImageStorage($request))->storeImage('admin' . DIRECTORY_SEPARATOR . 'profile', 'Admin_ImgProfile', $thumbnail);

        /** @var AdminIndexerResponse $indexResponse */
        $indexResponse = $this->queryBus->ask(new AdminIndexerQuery($request->input("Id_Admin")));
        $imgProfile = $this->indexOrEmpty($indexResponse, 'Admin_ImgProfile');
        $imgProfileThumb = $this->indexOrEmpty($indexResponse, 'Admin_ImgProfile_Thumb');

        /** @var AdminUpdaterResponse $response */
        $response = $this->queryBus->ask(new AdminUpdaterQuery(
            $request->input("Id_Admin"),
            Str::title($request->input("Admin_Name")),
            Str::title($request->input("Admin_LastName")),
            Str::upper($request->input("Admin_Abrv")),
            $request->input("Admin_NoDocument"),
            $request->input("Admin_Email"),
            $request->input("Admin_EmailAddress"),
            $request->input("Admin_Address"),
            $request->input("Admin_Phone"),
            $request->input("Admin_Color"),
            $request->input("Admin_IsAssignable"),
            isset($image) ? $image->getUrl() : $imgProfile,
            isset($image) ? $image->getThumbnail() : $imgProfileThumb,
            $request->input("Admin_Status"),
            $request->input("Id_TypeDocument"),
            $request->input("Id_AdminRole"),
            $request->input("Id_Country"),
            $request->input("Id_State"),
            $request->input("Id_City")
        ));

        $this->history->updateBasic($request->input("Id_Admin"), $request);

        $oResponse["Response_Status"]           = $response->response()[0]->Response_Status;
        $oResponse["Response_Code"]             = $response->response()[0]->Response_Code;
        $oResponse["Response_Domain"]           = $this->domain;
        $oResponse["Response_Message"]          = $response->response()[0]->Response_Message;
        $oResponse["Response_Data"]             = null;
        $oResponse["Response_Error_Message"]    = $response->response()[0]->Response_Message;
        $oResponse["Response_Error_Reason"]     = $response->response()[0]->Response_Reason;


        return ResponseBuilder::Response($oResponse);
    }
}
