<?php
namespace App\Http\Controllers\Mail;

class c_Mail_Table {
    
    private $Font_Family 		= "Segoe, 'Segoe UI', 'DejaVu Sans', 'Trebuchet MS', Verdana, 'sans-serif'";
    public $Color_Primary		= "#f56a2a";
	public $Color_Secondary	= "#f56a2a";

	public $Color_White		= "#FCFCFC";
	public $Color_White_Light	= "#FFFFFF";
	public $Color_White_Dark	= "#F3F3F3";

	public $Color_Black		= "#777777";
	public $Color_Black_Light	= "#999999";
	public $Color_Black_Dark	= "#222222";

	public $Color_Blue 		= "#007aff";
    public $Color_Green 		= "#34c759";
    public $Color_Indigo 		= "#5856d6";
    public $Color_Orange 		= "#ff9500";
    public $Color_Pink 		= "#ff2d55";
    public $Color_Purple 		= "#af52de";
    public $Color_Red 			= "#ff3b30";
    public $Color_Teal 		= "#5ac8fa";
    public $Color_Yellow 		= "#ffcc00";

	public $Padding			= "5px 20px";
    public $Margin				= "10px 0";

    /**
     * @var array
     */
    private $mailRowList = [];
    public $borderWidth = '1px';

    public function addRow (c_Mail_Row $row) {
        $this->mailRowList[] = $row;
        $row->table = $this;
        return $this;
    }

    public function __toString() {
        $rows = implode ('', $this->mailRowList);
        return "<table style=\"border: " . $this->borderWidth . " solid black; width: 100%; border-collapse: collapse; font-family: $this->Font_Family;\">$rows</table>";
    }

    public function basicRow ($columns = []) {
        $row = new c_Mail_Row();
        foreach ($columns as $column) {
            $row->addColumn($column);
        }
        $this->addRow($row);
        return $this;
    }

    public static function table () {
        return new c_Mail_Table();
    }

    public static function row () {
        return new c_Mail_Row();
    }

    public static function darkColumn ($text) {
        return new c_Mail_Column_Dark($text);
    }

    public static function baseColumn ($text) {
        return new c_Mail_Column_Base($text);
    }

    public static function orangeColumn ($text) {
        return new c_Mail_Column_Orange($text);
    }

    public static function unBorderedColumn ($text) {
        return new c_Mail_Column_UnBordered($text);
    }
    
}