<?php

namespace App\DBTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class PassengerMother {
    
    public static function build1($id = 1, $idBooking = 1, $idTypeDocument = 1, $idUserCountry = 1, $idTypeRate = 1) {
        $faker = Factory::create();
        return [
            'Id_Passenger'                  => $id,
            'Passenger_DateCreate'          => date('Y-m-d H:i:s'),
            'Passenger_DateEdit'            => date('Y-m-d H:i:s'),
            'Passenger_Name'                => $faker->firstName,
            'Passenger_LastName'            => $faker->lastName,
            'Passenger_Email'               => $faker->email,
            'Passenger_Phone'               => $faker->phoneNumber,
            'Passenger_Gender'              => 1,
            'Passenger_DOB'                 => date('Y-m-d'),
            'Passenger_NoDocument'          => $faker->text(20),
            'Passenger_Restriction'         => '',
            'Passenger_Extras'              => '',
            'Passenger_ImgDocument1'        => '',
            'Passenger_ImgDocument2'        => '',
            'Passenger_Token'               => '',
            'Passenger_Reportable'          => 2,
            'Passenger_Status'              => 2,
            'Passenger_PaymentStatus'       => 1,
            'Passenger_InfoStatus'          => 1,
            
            'Id_Booking'                    => $idBooking,
            'Id_TypeDocument'               => $idTypeDocument,
            'Id_UserCountry'                => $idUserCountry,
            'Id_TypeRate'                   => $idTypeRate
        ];
    }

    public static function push1($id = 1, $idBooking = 1, $idTypeDocument = 1, $idUserCountry = 1, $idTypeRate = 1) {
        return self::push(self::build1($id, $idBooking, $idTypeDocument, $idUserCountry, $idTypeRate));
    }

    private static function push($object)
    {
        DB::select(
            "CALL `sp_passenger_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
            [
                $object['Passenger_Name'],
                $object['Passenger_LastName'],
                $object['Passenger_Email'],
                $object['Passenger_Phone'],
                $object['Passenger_Gender'],
                $object['Passenger_DOB'],
                $object['Passenger_NoDocument'],
                $object['Passenger_Restriction'],
                $object['Passenger_Extras'],
                $object['Passenger_Reportable'],
                $object['Passenger_Status'],
                $object['Id_Booking'],
                $object['Id_TypeDocument'],
                $object['Id_TypeRate'],
                $object['Id_UserCountry'],
            ]
        );
        return $object;
    }

}