<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;
use Faker\Factory;

class AdminMother {
    
    public static function build1($id = 1, $idTypeDocument = 1, $idAdminRole = 1, $idCountry = 1, $idState = 1, $idCity = 1) {
        $faker = Factory::create();
        return [
            'Id_Admin'					=> $id,
            'Admin_Name'				=> 'adsdss',
            'Admin_LastName'			=> 'asdasd',
            'Admin_Abrv'    			=> 'asd',
            'Admin_NoDocument'			=> '123123',
            'Admin_Password'			=> sha1('123123'),
            'Admin_Email'				=> 'asdas@asdas',
            'Admin_Address'				=> 'asdasd',
            'Admin_Phone'				=> '123452231',
            'Admin_Color'               => $faker->hexColor,
            'Admin_Status'				=> 2,
            'Id_TypeDocument'			=> $idTypeDocument,
            'Id_AdminRole'			    => $idAdminRole,
            'Id_Country'			    => $idCountry,
            'Id_State'  			    => $idState,
            'Id_City'   			    => $idCity,
        ];
    }
    public static function push1($id = 1, $idTypeDocument = 1, $idAdminRole = 1, $idCountry = 1, $idState = 1, $idCity = 1) {
        return self::push(self::build1($id, $idTypeDocument, $idAdminRole, $idCountry, $idState, $idCity));
    }

    private static function push($object) {
        DB::select("CALL `sp_admin_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $object['Admin_Name'],
            $object['Admin_LastName'],
            $object['Admin_Abrv'],
            $object['Admin_NoDocument'],
            $object['Admin_Email'],
            $object['Admin_Address'],
            $object['Admin_Phone'],
            $object['Admin_Color'],
            $object['Admin_Status'],
            $object['Id_TypeDocument'],
            $object['Id_AdminRole'],
            $object['Id_Country'],
            $object['Id_State'],
            $object['Id_City'],
        ]);
        return $object;
    }

}