<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TypeProviderMother
{
    
    public static function build1($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_TypeProvider'       => $id,
            'TypeProvider_Name'     => Str::title($faker->text(rand(5, 100))),
            'TypeProvider_Abrv'     => Str::upper(Util::generateString(4)),
            'TypeProvider_Endorser' => $faker->randomElement([1, 2]),
            'TypeProvider_Status'   => 2
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_type_provider_insert` (?,?,?,?)", [
            $object['TypeProvider_Name'],
            $object['TypeProvider_Abrv'],
            $object['TypeProvider_Endorser'],
            $object['TypeProvider_Status']
        ]);
        $object['Id_TypeProvider'] = $response[0]->Response_Id;
        return $object;
    }
}
