<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class TypeExtraMother
{
    public static function build1($id = 1)
    {
        $faker = \Faker\Factory::create();

        return [
            'Id_TypeExtra' => $id,
            'TypeExtra_Name' => $faker->text(rand(5, 250)),
            'TypeExtra_Abrv' => Util::generateString(4),
            'TypeExtra_Lock' => 1,
            'TypeExtra_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_type_extra_insert`(?,?,?)", [
            $object['TypeExtra_Name'],
            $object['TypeExtra_Abrv'],
            $object['TypeExtra_Status'],
        ]);
        $object['Id_TypeExtra'] = $response[0]->Response_Id;
        return $object;
    }

    public static function clear()
    {
        return array_merge(
            [
                TC::TYPE_EXTRA,
                TC::TYPE_EXTRA_TRANSL
            ]
        );
    }
}
