<?php

namespace App\DBRealTestSupport;

use App\Config\DatabaseConfig;

class TableCreation
{

    private static $createdTables = [];

    public static function reset()
    {
        self::$createdTables = [];
        $db = DatabaseConfig::db();
        $db->query("SET FOREIGN_KEY_CHECKS = 0;
            SET GROUP_CONCAT_MAX_LEN=32768;
            SET @tables = NULL;
            SELECT GROUP_CONCAT('`', table_name, '`') INTO @tables
            FROM information_schema.tables
            WHERE table_schema = (SELECT DATABASE());        
            SELECT IFNULL(@tables,'dummy') INTO @tables;

            SET @tables = CONCAT('DROP TABLE IF EXISTS ', @tables);
            PREPARE stmt FROM @tables;
            EXECUTE stmt;
            DEALLOCATE PREPARE stmt;
            SET FOREIGN_KEY_CHECKS = 1");
    }

    public static function createTable($tableName)
    {

        if (array_key_exists($tableName, self::$createdTables)) {
            return;
        }

        $sqlDir = self::sqlDir();

        $tableDir = $sqlDir . $tableName . '.sql';
        $content = file_get_contents($tableDir);

        $db = DatabaseConfig::db();
        $db->query($content);
        self::$createdTables[$tableName] = true;
    }

    public static function cDatabase()
    {
        self::createTable('db_salkantay');
    }

    public static function sqlDir(): string
    {
        $cut = DIRECTORY_SEPARATOR;
        return __DIR__ . "$cut";
    }

    public const LANGUAGE = 't_language';
    public const TYPE_DOCUMENT = 't_type_document';
    public const TYPE_DOCUMENT_TRANSL = 't_type_document_transl';
    public const ADMIN_ROLE = 't_admin_role';
    public const ADMIN_ROLE_AUTH = 't_admin_role_auth';
    public const COUNTRY = 't_country';
    public const DIRECTORY = 't_directory';
    public const STATE = 't_state';
    public const CITY = 't_city';
    public const ADMIN = 't_admin';
    public const ADMIN_SESSION = 't_admin_session';
    public const CREDENTIAL = 't_credential';
    public const INVOICE = 't_invoice';
    public const INVOICE_DETAIL = 't_invoice_detail';
    public const INVOICE_FEE = 't_invoice_fee';
    public const INVOICE_FEE_DETAIL = 't_invoice_fee_detail';
    public const package = 't_package';
    public const package_tour = 't_package_tour';
    public const PACKAGE_FEE = 't_package_fee';
    public const PACKAGE_RATE = 't_package_rate';
    public const PACKAGE_TRANSL = 't_package_transl';
    public const passenger = 't_passenger';
    public const user_country = 't_user_country';
    public const category_tour = 't_category_tour';
    public const type_tour = 't_type_tour';
    public const type_tour_transl = 't_type_tour_transl';
    public const type_rate = 't_type_rate';
    public const type_rate_transl = 't_type_rate_transl';
    public const type_payment = 't_type_payment';
    public const type_payment_transl = 't_type_payment_transl';
    public const user_package_rate = 't_user_package_rate';
    public const tour = 't_tour';
    public const tour_transl = 't_tour_transl';
    public const group = 't_group';
    public const booking_relationship = 't_booking_relationship';
    public const booking_referred_from = 't_booking_referred_from';
    public const user = 't_user';
    public const booking = 't_booking';
    public const booking_tour = 't_booking_tour';
    public const booking_tour_passenger = 't_booking_tour_passenger';
    public const TYPE_UPGRADE = 't_type_upgrade';
    public const TYPE_UPGRADE_TRANSL = 't_type_upgrade_transl';
    public const TYPE_EXTRA = 't_type_extra';
    public const TYPE_EXTRA_TRANSL = 't_type_extra_transl';
    public const UPGRADE = 't_upgrade';
    public const UPGRADE_TRANSL = 't_upgrade_transl';
    public const EXTRA = 't_extra';
    public const EXTRA_TRANSL = 't_extra_transl';
    public const BOOKING_UPGRADE = 't_booking_upgrade';
    public const BOOKING_UPGRADE_PASSENGER = 't_booking_upgrade_passenger';
    public const BOOKING_EXTRA = 't_booking_extra';
    public const BOOKING_EXTRA_PASSENGER = 't_booking_extra_passenger';
    public const BOOKING_EQUIPMENT = 't_booking_equipment';
    public const BOOKING_EQUIPMENT_PASSENGER = 't_booking_equipment_passenger';
    public const cash_movement = 't_cash_movement';
    public const cash_movement_detail = 't_cash_movement_detail';
    public const htl_camp = 't_htl_camp';
    public const htl_room = 't_htl_room';
    public const htl_usage = 't_htl_usage';
    public const htl_usage_passenger = 't_htl_usage_passenger';
    public const tour_htl_camp = 't_tour_htl_camp';
    public const type_item = 't_type_item';
    public const type_equipment = 't_type_equipment';
    public const type_equipment_transl = 't_type_equipment_transl';
    public const item = 't_item';
    public const equipment = 't_equipment';
    public const equipment_transl = 't_equipment_transl';
    public const package_tour_equipment = 't_package_tour_equipment';
    public const PACKAGE_TOUR_EXTRA = 't_package_tour_extra';
    public const PACKAGE_TOUR_UPGRADE = 't_package_tour_upgrade';
    public const pax_information = 't_pax_information';
    public const pax_information_passenger = 't_pax_information_passenger';
    public const question = 't_question';
    public const QUESTION_TRANSL = 't_question_transl';
    public const group_passenger = 't_group_passenger';
    public const group_provider = 't_group_provider';
    public const type_provider = 't_type_provider';
    public const redistribution = 't_redistribution';
    public const REDISTRIBUTION_DETAIL = 't_redistribution_detail';
    public const PASSENGER_REVIEW = 't_passenger_review';
    public const GROUP_PROVIDER_REVIEW = 't_group_provider_review';
    public const PROVIDER = 't_provider';
    public const TOUR_QUESTION = 't_tour_question';
    public const MODULE_NOTIFICATION = 't_module_notification';
    public const MODULE_NOTIFICATION_PARAM = 't_module_notification_param';
    public const EXTERNAL = 't_external';
    public const EXTERNAL_USER = 't_external_user';
    public const EXTERNAL_USER_PASSENGER = 't_external_user_passenger';
    public const EXTERNAL_REVIEW = 't_external_review';
    public const EXTERNAL_REVIEW_PROVIDER = 't_external_review_provider';
    public const REVIEW_SESSION = 't_review_session';
    public const REVIEW_SESSION_GROUP_PASSENGER = 't_review_session_group_passenger';
    public const LEAD = 't_lead';
    public const LEAD_BOOKING = 't_lead_booking';
    public const LEAD_PASSENGER = 't_lead_passenger';
    public const LEAD_BOOKING_TOUR = 't_lead_booking_tour';
    public const LEAD_BOOKING_TOUR_PASSENGER = 't_lead_booking_tour_passenger';
    public const LEAD_BOOKING_SERVICE = 't_lead_booking_service';
    public const LEAD_BOOKING_SERVICE_PASSENGER = 't_lead_booking_service_passenger';
    public const REVIEW_NOTIFICATION = 't_review_notification';
    public const PROVIDER_TYPE_PROVIDER = 't_provider_type_provider';
    public const QUESTION_TYPE_PROVIDER = 't_question_type_provider';
    public const STATUS_GROUP = 't_status_group';
    public const STATUS_GROUP_PROVIDER = 't_status_group_provider';
    public const TYPE_BOOKING_ASSIGN = 't_type_booking_assign';
    public const BOOKING_ASSIGN = 't_booking_assign';
    public const WEB_CONTACT = 't_web_contact';
    public const WEB_CONTACT_MESSAGE = 't_web_contact_message';
    public const WEB_CONTACT_MESSAGE_DETAIL = 't_web_contact_message_detail';
    public const FACT_TYPE_DOCUMENT = 't_fact_type_document';
    public const FACT_TYPE_RECEIPT = 't_fact_type_receipt';
    public const FACT_TYPE_OPERATION = 't_fact_type_operation';
    public const FACT_UNIT = 't_fact_unit';
    public const FACT_PRODUCT = 't_fact_product';
    public const FACT_RECEIPT = 't_fact_receipt';
    public const FACT_RECEIPT_DETAIL = 't_fact_receipt_detail';
    public const CASH_MOVEMENT_FACT_RECEIPT = 't_cash_movement_fact_receipt';
    public const BOOKING_ADDITIONAL = 't_booking_additional';
    public const HTL_TYPE_CAMP = 't_htl_type_camp';
    public const HTL_TYPE_ROOM = 't_htl_type_room';
    public const HTL_BED = 't_htl_bed';
    public const HTL_TYPE_ROOM_BED = 't_htl_type_room_bed';
    public const HTL_CAMP_SCHEDULE = 't_htl_camp_schedule';
    public const HTL_CAMP_BOOKING = 't_htl_camp_booking';
    public const HTL_CAMP_BOOKING_PASSENGER = 't_htl_camp_booking_passenger';
    public const FACT_PAYMENT_METHOD = 't_fact_payment_method';
    public const FACT_CURRENCY = 't_fact_currency';
    public const GROUP_PASSENGER_MEDIA = 't_group_passenger_media';
    public const GROUP_PROVIDER_MEDIA = 't_group_provider_media';

    public static function clearTables(...$tables)
    {
        $uniqueTables = array_unique($tables);
        $dbStatement = "SET FOREIGN_KEY_CHECKS=0;\n";
        foreach ($uniqueTables as $table) {
            $dbStatement .= "DELETE FROM `$table`;\n";
        }
        $dbStatement .= 'SET FOREIGN_KEY_CHECKS=1;';
        $db = DatabaseConfig::db();
        $db->query($dbStatement);
    }
}
