<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class StatusGroupMother
{

    public static function build1($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_StatusGroup'            => $id,
            'StatusGroup_Name'          => $faker->text(rand(5, 250)),
            'StatusGroup_Abrv'          => $faker->text(rand(5, 10)),
            'StatusGroup_Color'         => $faker->text(rand(5, 50)),
            'StatusGroup_Status'        => $faker->randomElement([1, 2]),
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_status_group_insert` (?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['StatusGroup_Name'],
            $object['StatusGroup_Abrv'],
            $object['StatusGroup_Color'],
            $object['StatusGroup_Status'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_StatusGroup'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::STATUS_GROUP];
    }
}
