<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class QuestionTypeProviderMother
{
    public static function build1($idQuestion, $idTypeProvider, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_QuestionTypeProvider' => $id,
            'QuestionTypeProvider_Show' => $faker->randomElement([1, 2]),
            'QuestionTypeProvider_ForPassenger' => $faker->randomElement([1, 2]),
            'QuestionTypeProvider_Status' => $faker->randomElement([2]),
            'Id_Question' => $idQuestion,
            'Id_TypeProvider' => $idTypeProvider
        ];
    }

    public static function push1($idQuestion, $idTypeProvider, $id = 1)
    {
        return self::push(self::build1($idQuestion, $idTypeProvider, $id));
    }

    private static function push($object)
    {
        $response = DB::select(
            "CALL `sp_question_type_provider_insert` (?,?,?,?,?,@sts,@cod,@msg,@id)",
            [
                $object['QuestionTypeProvider_Show'],
                $object['QuestionTypeProvider_ForPassenger'],
                $object['QuestionTypeProvider_Status'],
                $object['Id_Question'],
                $object['Id_TypeProvider']
            ]
        );
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_QuestionTypeProvider'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [
            TC::QUESTION_TYPE_PROVIDER,
            TC::question,
            TC::QUESTION_TRANSL,
            TC::PROVIDER,
            TC::type_provider,
            TC::COUNTRY,
            TC::STATE,
            TC::CITY
        ];
    }
}
