<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ProviderTypeProviderMother
{
    public static function build1($idProvider, $idTypeProvider, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_ProviderTypeProvider' => $id,
            'ProviderTypeProvider_Status' => $faker->randomElement([2]),
            'Id_Provider' => $idProvider,
            'Id_TypeProvider' => $idTypeProvider
        ];
    }

    public static function push1($idProvider, $idTypeProvider, $id = 1)
    {
        return self::push(self::build1($idProvider, $idTypeProvider, $id));
    }

    private static function push($object)
    {
        $response = DB::select(
            "CALL `sp_provider_type_provider_insert` (?,?,?,@sts,@cod,@msg,@id)",
            [
                $object['ProviderTypeProvider_Status'],
                $object['Id_Provider'],
                $object['Id_TypeProvider']
            ]
        );
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_ProviderTypeProvider'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [
            TC::PROVIDER_TYPE_PROVIDER,
            TC::PROVIDER,
            TC::type_provider,
            TC::COUNTRY,
            TC::STATE,
            TC::CITY
        ];
    }
}
