<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class HtlCampBookingMother
{

    public static function build1($idHtlCampSchedule = null, $idBookingTour = null, $id = 0)
    {
        $faker = Factory::create();
        $idHtlCampSchedule = $idHtlCampSchedule ?? HtlCampScheduleMother::push1()['Id_HtlCampSchedule'];
        return [
            'Id_HtlCampBooking'             => $id,
            'HtlCampBooking_Date'           => date('Y-m-d H:i:s'),
            'HtlCampBooking_DateStart'      => date('Y-m-d H:i:s', strtotime('+' . rand(1, 30) . ' days')),
            'HtlCampBooking_Amount'         => rand(5, 1000),
            'HtlCampBooking_Status'         => $faker->randomElement([1, 2]),
            'HtlCampBooking_Lock'           => $faker->randomElement([1, 2]),
            'HtlCampBooking_Remark'         => $faker->text(rand(5, 250)),
            'Id_HtlCampSchedule'            => $idHtlCampSchedule,
            'Id_BookingTour'                => $idBookingTour
        ];
    }

    public static function push1($idHtlCampSchedule = null, $idBookingTour = null, $id = 0)
    {
        return self::push(self::build1($idHtlCampSchedule, $idBookingTour, $id));
    }

    private static function push($object)
    {
        DB::select("INSERT INTO " . TC::HTL_CAMP_BOOKING . " (
            `Id_HtlCampBooking`,
            `HtlCampBooking_Date`,
            `HtlCampBooking_DateStart`,
            `HtlCampBooking_Amount`,
            `HtlCampBooking_Status`,
            `HtlCampBooking_Lock`,
            `HtlCampBooking_Remark`,
            `Id_HtlCampSchedule`,
            `Id_BookingTour`
        ) VALUES (?,?,?,?,?,?,?,?,?)", [
            $object['Id_HtlCampBooking'] === 0 ? null : $object['Id_HtlCampBooking'],
            $object['HtlCampBooking_Date'],
            $object['HtlCampBooking_DateStart'],
            $object['HtlCampBooking_Amount'],
            $object['HtlCampBooking_Status'],
            $object['HtlCampBooking_Lock'],
            $object['HtlCampBooking_Remark'],
            $object['Id_HtlCampSchedule'],
            $object['Id_BookingTour']
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as Id');
        $object['Id_HtlCampBooking'] = $response[0]->Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::HTL_CAMP_BOOKING, ...HtlCampMother::tablesToClear()];
    }
}
